<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Compra extends Model
{
    protected $table = 'compras';
    protected $primaryKey = 'id_compra';

    protected $fillable = [
        'id_compra', 'id_usuario','id_local', 'id_proveedor', 'tipo_comprobante', 'numero_comprobante', 'fecha_compra', 'tipo_compra', 'fecha_pago', 'total_compra', 'observacion', 'estado'
    ];

    public function usuario()
    {
        return $this->belongsTo('App\Models\Usuario', 'id_usuario');
    }
    public function local()
    {
        return $this->belongsTo('App\Models\Local', 'id_local');
    }
    public function proveedor()
    {
        return $this->belongsTo('App\Models\Proveedor', 'id_proveedor');
    }
}
