<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DetalleCredito extends Model
{
    protected $table = 'detalle_credito';
    protected $primaryKey = 'id_detalle_credito';

    protected $fillable = [
        'id_detalle_credito', 'id_usuario','id_venta','id_proforma', 'fecha_pago', 'monto', 'observacion', 'estado'
    ];

    public function venta()
    {
        return $this->belongsTo('App\Models\Venta', 'id_venta');
    }
    public function usuario()
    {
        return $this->belongsTo('App\Models\Usuario', 'id_usuario');
    }
    public function proforma()
    {
        return $this->belongsTo('App\Models\Proforma', 'id_proforma');
    }
}
