<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProductoLocal extends Model
{
    protected $table = 'producto_local';
    protected $primaryKey = 'id_producto_local';

    protected $fillable = [
        'id_producto_local', 'id_producto','id_local', 'stock', 'stock_alerta', 'estado'
    ];

    public function local()
    {
        return $this->belongsTo('App\Models\Local', 'id_local');
    }
    public function producto()
    {
        return $this->belongsTo('App\Models\Producto', 'id_producto');
    }
}
