<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class VentasCredito extends Model
{
    protected $table = 'ventas_credito';
    protected $primaryKey = 'id_ventas_credito';

    protected $fillable = [
        'id_ventas_credito', 'id_venta', 'nombre_cuota', 'numero_cuota', 'monto_cuota', 'fecha_pago_cuota', 'estado'
    ];

    public function venta()
    {
        return $this->belongsTo('App\Models\Venta', 'id_venta');
    }
}
