<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsuariosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('usuarios', function (Blueprint $table) {
            $table->integer('id_usuario')->autoIncrement();
            $table->integer('id_rol');
            $table->integer('id_local');
            $table->string('username', 20);
            $table->string('password', 200);
            $table->string('nombres', 50);
            $table->string('apellidos', 50);
            $table->string('dni', 8)->nullable();
            $table->date('fecha_nacimiento')->nullable();
            $table->string('domicilio', 200)->nullable();
            $table->string('email', 100)->nullable();
            $table->string('telefono', 15)->nullable();
            $table->string('genero', 15)->nullable();
            $table->string('url_avatar', 100)->nullable();
            $table->tinyInteger('estado')->default('1');
            $table->rememberToken();
            $table->timestamps();

            $table->foreign('id_rol')
                  ->references('id_rol')->on('rol')
                  ->onUpdate('cascade')
                  ->onDelete('cascade');

            $table->foreign('id_local')
                  ->references('id_local')->on('local')
                  ->onUpdate('cascade')
                  ->onDelete('cascade');  
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('usuarios');
    }
}
