<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductoLocalTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('producto_local', function (Blueprint $table) {
            $table->integer('id_producto_local')->autoIncrement();
            $table->integer('id_producto');
            $table->integer('id_local');
            $table->decimal('stock', 9, 2)->default('1000050.00');
            $table->integer('stock_alerta')->default('10');
            $table->tinyInteger('estado')->default('1');
            $table->timestamps();

            $table->foreign('id_producto')
                  ->references('id_producto')->on('productos')
                  ->onUpdate('cascade')
                  ->onDelete('cascade');

            $table->foreign('id_local')
                  ->references('id_local')->on('local')
                  ->onUpdate('cascade')
                  ->onDelete('cascade');      
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('producto_local');
    }
}
