@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">REGISTRO DE GUIAS DE REMISION EMITIDAS</h4>
           
            <div class="ui equal width grid">
                <div class="row">
                    <div class="column">
                        <form id="frmBuscar" autocomplete="off" method="GET" action="{{ url('guia/buscar') }}" >
                            <div class="ui action small input" >
                                  <input type="text" placeholder="Buscar..." name="search">
                                  <button type="submit" class="ui icon button " title="Clic para buscar"><i class="search icon"></i></button>
                            </div>
                        </form>
                    </div>

                    <div class="column export_files" style="text-align: right">
                        <div class="ui right floated violet button btn_reporte"><i class="download icon"></i>Descargar lista</div>
                    </div> 
                </div>
            </div>

            <table class="ui celled striped table">
                <thead>
                    <tr>
                        <th class="head_table">N°</th>
                        <th class="head_table">N° Guia</th>
                        <th class="head_table">Cliente</th>
                        <th class="head_table">Direccion de LLegada</th>
                       
                        <th class="head_table">Fecha de Traslado</th>
                        <th class="head_table">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                   <?php /**/ $i = $data->firstItem() /**/ ?>
                    @foreach ($data as $guia)
                    <tr data-table="{{ $guia->id_guia_remision }}">
                        <td>{{ $i }}</td>
                        <td>{{ $guia->nombre_guia }}</td>
                        <td>{{ $guia->id_venta != null ? $guia->venta->cliente->nombre :  $guia->cliente->nombre }}</td>
                        <td>{{ $guia->punto_llegada }}</td>
                        
                        <td>{{ $guia->fecha_traslado }}</td>
                        <td>                            
                            <a class="ui mini vertical animated blue button" title="Ver informacion detallada" href="{{ url('guia/detalles/'.$guia->id_guia_remision) }}">
                                <div class="hidden content">Detalles</div>
                                <div class="visible content"><i class="search icon"></i></div>
                            </a>
                        </td>
                    </tr>
                    <?php /**/ $i++ /**/ ?>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="7">
                            @include('layout.includes.pagination')
                        </th>
                    </tr>
                </tfoot>
            </table>

        </div>
    </div>

@stop

@section('scripts')
    <script src="{{ asset('js/guia/listar.js') }}"></script>
@stop


