@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">GUIAS DE REMISION ELECTRONICAS EMITIDAS</h4>
           
           <div class="ui equal width grid">
                <div class="row">
                    <div class="column export_files" style="text-align: right">
                        <select class="ui small input dropdown" name="estado_envio">
                            <option value="">Seleccione</option>
                            <option value="TODOS">TODOS</option>
                            <option value="0">ACEPTADOS</option>
                            <option value="1">RECHAZADOS</option>
                            <option value="2">NO ENVIADOS</option>
                            <option value="3">PENDIENTES</option>
                        </select>  
                    </div>
                </div>
            </div> 

            <table class="ui celled striped table">
                <thead>
                    <tr>
                        <th class="head_table">N°</th>
                        <th class="head_table">Cliente</th>
                        <th class="head_table">N° Guia</th>
                        <th class="head_table">Fecha Emision</th>
                        <th class="head_table">Fecha de Envio</th>
                        <th class="head_table">Estado Envio</th>
                        <th class="head_table">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                   <?php /**/ $i = $data->firstItem() /**/ ?>
                    @foreach ($data as $guia)
                    <tr>
                        <td>{{ $i }}</td>
                        
                        <td>{{ $guia->id_venta != null ? $guia->venta->cliente->nombre :  $guia->cliente->nombre  }}</td>
                        <td>{{ $guia->nombre_guia }}</td>
                        <td>{{ $guia->fecha_emision }}</td>
                        <td>{{ $guia->updated_at }}</td>
                        <td>
                            @if($guia->estado_envio == "ACEPTADO")
                                <div class="ui green label">{{ $guia->estado_envio }}</div>
                            @elseif ($guia->estado_envio == "RECHAZADO")
                                <div class="ui yellow label">{{ $guia->estado_envio }}</div>
                            @elseif ($guia->estado_envio == "NO ENVIADO")
                                <div class="ui red label">{{ $guia->estado_envio }}</div>
                            @elseif ($guia->estado_envio == "REGISTRADO")
                                <div class="ui purple label">PENDIENTE</div>    
                            @endif
                        </td>
                        <td>                            
                            <a class="ui mini vertical animated blue button" title="Ver informacion detallada" href="{{ url('guia/detalles_electronico/'.$guia->id_guia_remision) }}">
                                <div class="hidden content">Detalles</div>
                                <div class="visible content"><i class="search icon"></i></div>
                            </a>
                        </td>
                    </tr>
                    <?php /**/ $i++ /**/ ?>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="7">
                            @include('layout.includes.pagination')
                        </th>
                    </tr>
                </tfoot>
            </table>

        </div>
    </div>

@stop

@section('scripts')
    <script src="{{ asset('js/guia/listar.js') }}"></script>
@stop


